<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "background_tasks".
 *
 * @property int $id
 * @property string $created_at
 * @property int $user_id
 * @property string $task
 * @property string $task_name
 * @property int $status
 */
class BackgroundTasks extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'background_tasks';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['created_at'], 'safe'],
            [['user_id', 'status'], 'default', 'value' => null],
            [['user_id', 'status'], 'integer'],
            [['task', 'task_name'], 'string'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'created_at' => 'Created At',
            'user_id' => 'User ID',
            'task' => 'Task',
            'task_name' => 'Task Name',
            'status' => 'Status',
        ];
    }
}
